
markup.push({

// -------------------------------------------------
// MARK: - output device block

AudioDeviceOutputBlock:
{
	"+": "OutputTemplate",
	geNodeClass: "AHKAudioDeviceOutputNode",
    h4PresetsId: "OutputDevicePresets",
	geOutputRank: 1, 	// outputs have an order of importance for status display
	gxTitle: "Output Device",
	gxDescriptionKeyPath: "node.deviceTitleMarkup",
	gxLibraryIcon: "library.output.device",
	gxLibraryDescription: "Send audio to an output",
	gxPopoverInfo: "OutputDevicePopover",
	gxChildViews:
	{
		deviceName: {
			"+": "LabelView.centery.lineSquash1.foreColorTheme1.size105.wrap.useMarkup",
			gxValueKey: "node.deviceTitleMarkup",
			axIsIgnored: true,		// avoid VO reading title twice (blockDescription covers it)
			axTitle: "Device name",
			gxFrameRect: "11,84,98,28",
		},
		deviceIcon: {
			nsClass: "GXDrawView",
			gxForePainter: "ImagePainter.block.output.device",
			gxValueKey: "node.deviceIcon",
			gxFrameRect: "20,36,80,48",
		},
	}
},

// MARK: - output device popover

OutputDevicePopover:
{
	"+": "PopoverTemplate",
	gxTitle: "Output Device",
	gxLayout: [	"H:|-12-[self(350)]-12-|",
				"V:|-12-[self]-12-|",
				"V:|-41-[group]-8-[presetsGroup]" ],
	gxChildViews:
	{
		title: "PopoverTitle",
		onOff: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup(),
		group: {
			"+": "GroupView",
			gxLayout: [	"H:|-0-[self]-0-|",
						"H:|-12-[device]-12-|",
						"V:|-10-[title]",
						"V:|-35-[device]-14-[volume(23)]-10-[advancedBtn]-0-[advanced]-0-|",
					    "H:|-14-[volumeLabel]-10-[volume]-5-[readout(36)]-13-|&alignBaseline",
			],
			gxChildViews:
			{
				title: groupTitleView("Audio Device"),
				device : {
					"+": "PopupMenuTemplate.useMarkup",
					axTitle: "Audio Device",
					gxDisableOnNil: false,
					gxHideOnNilValue: false,
					gxValueKey: "node.menuItemIdentity",
					gxMenuItemsKeyPath: "node.deviceListMenuItems"
				},
				volume:	{
					"+": "SliderView",
					gxValueKey: "node.gain",
					gxDefaultValue: 1,
					gxBaselineOffset: 7,
					axTitle: "Output Volume",
					axFormatter: "PercentFormatter",
				},
				volumeLabel: labelView("Output Volume:"),
				readout: {
					"+": "ReadoutView.baseline1",
					gxFormatter: "PercentFormatter",
					gxValueKey: "node.gain",
					gxIntrinsicHeight: 12
				},
				advancedBtn: {
					"+": "AdvancedGroupButton",
					gxTitle: "<disclosure/> Advanced",
					gxValueKey: "uiState.advancedExpanded",
					axFormatter: disclosureAxFormatter("Advanced"),
				},
				advanced: {
					"+": "ExpandingGroupView.noTopStroke",
					gxValueKey: "uiState.advancedExpanded",
					//axIsIgnored: false,
					//axTitle: "Advanced",
					gxCollapsible: true,
					gxCollapsedSize: 1,	// lets bottom stroke show
					gxExtraSize: 12,
					gxLayout: [
							   "H:|-0-[self]-0-|",
							   "H:[leftLabel]-[left(160)]-24-|&alignBaseline",
							   "H:[rightLabel]-[right(160)]-24-|&alignBaseline",
							   "V:|-8-[left]-8-[right]",
					],
					gxChildViews:
					{
						left: {
							"+": "PopupMenuTemplate",
							gxValueKey: "node.leftChannel",
							gxMenuItemsKeyPath: "node.channelMenuItems",
							axTitle: "Left Channel",
						},
						leftLabel: labelView("Left Channel:"),
						right: {
							"+": "PopupMenuTemplate",
							gxValueKey: "node.rightChannel",
							gxMenuItemsKeyPath: "node.channelMenuItems",
							axTitle: "Right Channel",
						},
						rightLabel: labelView("Right Channel:"),
					}
				}
			}
		}
	}
},


})
